package com.androidbook.shapeshifter;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;

public class TweenActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.tween);
		
	     // Obsługa przycisku Wygaś.
		final Button fadeButton = (Button) findViewById(R.id.ButtonAlpha);
		fadeButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				performAnimation(R.anim.transparency);
			}
		});
			
		// Obsługa przycisku Powiększ.
		final Button growButton = (Button) findViewById(R.id.ButtonScale);
		growButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				performAnimation(R.anim.grow);
			}
		});
		
	     // Obsługa przycisku Przesuń.
		final Button moveButton = (Button) findViewById(R.id.ButtonTranslate);
		moveButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				performAnimation(R.anim.translate_position);
			}
		});
			
		// Obsługa przycisku Obrót.
		final Button spinButton = (Button) findViewById(R.id.ButtonRotate);
		spinButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				performAnimation(R.anim.spin);
			}
		});
		
		// Obsługa przycisku Wszystkie.
		final Button allButton = (Button) findViewById(R.id.ButtonAll);
		allButton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				performAnimation(R.anim.shakennotstirred);
			}
		});
	
	}
		
	private void performAnimation(int animationResourceID)
	{
	    // Będziemy animować kontrolkę ImageView.
		ImageView reusableImageView = (ImageView)findViewById(R.id.ImageViewForTweening);
		reusableImageView.setImageResource(R.drawable.green_rect);
		reusableImageView.setVisibility(View.VISIBLE);
		
		// Wczytujemy odpowiednią animację.
        Animation an =  AnimationUtils.loadAnimation(this, animationResourceID);
        // Rejestracja odbiorcy zdarzeń, abyśmy mogli wyłączać i ponownie 
        // włączać przyciski.
        an.setAnimationListener(new MyAnimationListener());	
        // Uruchomienie animacji.
        reusableImageView.startAnimation(an);	
	}
	



	private void toggleButtons(boolean clickableState)
	{
	    // Obsługa przycisku Wygaś.
		final Button fadeButton = (Button) findViewById(R.id.ButtonAlpha);
		fadeButton.setClickable(clickableState);
			
		// Obsługa przycisku Powiększ.
		final Button growButton = (Button) findViewById(R.id.ButtonScale);
		growButton.setClickable(clickableState);
		
	     // Obsługa przycisku Przesuń.
		final Button moveButton = (Button) findViewById(R.id.ButtonTranslate);
		moveButton.setClickable(clickableState);
		
		// Obsługa przycisku Obrót.
		final Button spinButton = (Button) findViewById(R.id.ButtonRotate);
		spinButton.setClickable(clickableState);
		
		// Obsługa przycisku Wszystkie.
		final Button allButton = (Button) findViewById(R.id.ButtonAll);
		allButton.setClickable(clickableState);
		
	}

	class MyAnimationListener implements Animation.AnimationListener {

		public void onAnimationEnd(Animation animation) {
			// Ukrycie kontrolki ImageView
			ImageView reusableImageView = (ImageView)findViewById(R.id.ImageViewForTweening);
			reusableImageView.setVisibility(View.INVISIBLE);
			
			// Włączenie wszystkich przycisków, gdy animacja została zakończona.
			toggleButtons(true);
			
		}

		public void onAnimationRepeat(Animation animation) {
			// Co robimy podczas trwania animacji? 
		}

		public void onAnimationStart(Animation animation) {
			// Wyłączamy wszystkie przyciski na czas trwania animacji.
			toggleButtons(false);
		}
		
	}

}
